<?php
/****************************************************************************************
 * LiveZilla script.php
 *
 * Copyright 2018 LiveZilla GmbH
 * All rights reserved.
 * LiveZilla is a registered trademark.
 *
 * Improper changes to this file may cause critical errors.
 ***************************************************************************************/

define("IN_LIVEZILLA",true);
//header('X-Content-Type-Options: nosniff');
header('Content-Type: application/javascript;charset=utf-8');
if(!defined("LIVEZILLA_PATH"))
    define("LIVEZILLA_PATH","./");

require(LIVEZILLA_PATH . "_definitions/definitions.inc.php");
require(LIVEZILLA_PATH . "_lib/functions.global.inc.php");
require(LIVEZILLA_PATH . "_definitions/definitions.dynamic.inc.php");
require(LIVEZILLA_PATH . "_definitions/definitions.protocol.inc.php");

@set_error_handler("handleError");
if(Server::InitDataProvider())
{
    Server::DefineURL("script.php");
    if(!empty($_GET["id"]))
    {
        if($_GET["id"] != "lzdefsc")
        {
            $code = utf8_decode(Configuration::GetCodeById($_GET["id"]));
            if($code == null)
                exit("document.write('Error: LiveZilla code does not exist');");
        }
        else
        {
            $_GET["hfk"] = true;

            require(LIVEZILLA_PATH . "_lib/functions.external.inc.php");
            $code = OverlayChat::GetDefaultScript(false,$_GET["id"]);
            $code = str_replace("<!--ptdata-->","",$code);
        }
    }
    else
        exit();
}
else
    exit();

$code = str_replace("<!--server-->",LIVEZILLA_URL."server.php",$code);

?>
function scrb64d(r){var e,n,a,t,f,d,h,i="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",o="",c=0;for(r=r.replace(/[^A-Za-z0-9\+\/\=]/g,"");c<r.length;)t=i.indexOf(r.charAt(c++)),f=i.indexOf(r.charAt(c++)),d=i.indexOf(r.charAt(c++)),h=i.indexOf(r.charAt(c++)),e=t<<2|f>>4,n=(15&f)<<4|d>>2,a=(3&d)<<6|h,o+=String.fromCharCode(e),64!=d&&(o+=String.fromCharCode(n)),64!=h&&(o+=String.fromCharCode(a));return o=o}
var scrttze = function (_sid,_script){

    var container = document.createElement("div");
    container.innerHTML = scrb64d(_script);

    if(document.getElementById(_sid))
        document.getElementById(_sid).parentNode.appendChild(container);
    else
        document.body.appendChild(container);
    if(document.getElementById('lz_r_scr_'+_sid)!=null)
        eval(document.getElementById('lz_r_scr_'+_sid).innerHTML);
    //comp
    else if(document.getElementById('lz_r_scr')!=null)
        eval(document.getElementById('lz_r_scr').innerHTML);

    if(document.getElementById('lz_textlink')!=null){
        var newScript = document.createElement("script");
        newScript.src = document.getElementById('lz_textlink').src;
        newScript.async = true;
        document.head.appendChild(newScript);
    }
    var links = document.getElementsByClassName('lz_text_link');
    for(var i=0;i<links.length;i++)
        if(links[i].className == 'lz_text_link'){
            var newScript = document.createElement("script");
            newScript.src = links[i].src;
            newScript.async = true;
            if(document.getElementById('es_'+links[i].id)==null)
            {
                newScript.id = 'es_'+links[i].id;
                document.head.appendChild(newScript);
            }
        }
};
function ssc(sid,script)
{
    if(window.addEventListener)
        window.addEventListener('load',function() {scrttze(sid,script);});
    else
        window.attachEvent('onload',function() {scrttze(sid,script);});
}
ssc('<?php echo $_GET["id"]; ?>','<?php echo base64_encode($code); ?>');
